<?php $__env->startPush('title', get_phrase('My courses')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <section class="my-course-content">
        <div class="profile-banner-area"></div>
        <div class="container profile-banner-area-container">
            <div class="row">
                <?php echo $__env->make('frontend.default.student.left_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col-lg-9 px-4">
                    <h4 class="g-title"><?php echo e(get_phrase('My Courses')); ?></h4>
                    <div class="row mt-5">
                        <?php $__currentLoopData = $my_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $course_progress = progress_bar($course->course_id);
                            ?>
                            <div class="col-lg-4 col-md-4 col-sm-6 mb-30">
                                <div class="card Ecard g-card c-card">
                                    <div class="card-head">
                                        <img src="<?php echo e(get_image($course->thumbnail)); ?>" alt="course-thumbnail">
                                    </div>
                                    <div class="card-body entry-details">
                                        <div class="info-card mb-15">
                                            <div class="creator">
                                                <img src="<?php echo e(get_image($course->user_photo)); ?>" alt="author-image">
                                                <h5><?php echo e($course->user_name); ?></h5>
                                            </div>
                                        </div>
                                        <div class="entry-title">
                                            <a href="<?php echo e(route('course.details', $course->slug)); ?>">
                                                <h3 class="w-100 ellipsis-line-2"><?php echo e(ucfirst($course->title)); ?></h3>
                                            </a>
                                        </div>
                                        <div class="single-progress">
                                            <div class="d-flex justify-content-between align-items-center mb-10">
                                                <h5><?php echo e(get_phrase('Progress')); ?></h5>
                                                <p><?php echo e($course_progress); ?>%</p>
                                            </div>
                                            <div class="progress" role="progressbar" aria-label="Basic example" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar" style="width: <?php echo e($course_progress); ?>%"></div>
                                            </div>
                                        </div>

                                        <div class="class-details pt-3">
                                            <div class="d-flex gap-3 justify-content-between">
                                                <?php if($course->expiry_date > 0 && $course->expiry_date < time()): ?>
                                                    <div class="class-status">
                                                        <span class="text-capitalize">
                                                            <?php echo e(get_phrase('Expired')); ?>:
                                                        </span>
                                                    </div>
                                                    <div class="class-status">
                                                        <span class="badge bg-danger text-capitalize">
                                                            <?php echo e(date('d M Y, H:i A', $course->expiry_date)); ?>

                                                        </span>
                                                    </div>
                                                <?php else: ?>
                                                    <?php if($course->expiry_date == 0): ?>
                                                        <div class="class-status">
                                                            <span class="text-capitalize">
                                                                <?php echo e(get_phrase('Expiry period')); ?>:
                                                            </span>
                                                        </div>
                                                        <div class="class-status">
                                                            <span class="badge bg-success text-capitalize">
                                                                <?php echo e(get_phrase('Lifetime Access')); ?>

                                                            </span>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="class-status">
                                                            <span class="text-capitalize">
                                                                <?php echo e(get_phrase('Expiration On')); ?>:
                                                            </span>
                                                        </div>
                                                        <div class="class-status">
                                                            <span class="badge bg-success text-capitalize">
                                                                <?php echo e(date('d M Y, H:i A', $course->expiry_date)); ?>

                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <?php
                                            $watch_history = App\Models\Watch_history::where('course_id', $course->course_id)
                                                ->where('student_id', auth()->user()->id)
                                                ->first();

                                            $lesson = App\Models\Lesson::where('course_id', $course->course_id)
                                                ->orderBy('sort', 'asc')
                                                ->first();

                                            if (!$watch_history && !$lesson) {
                                                $url = route('course.player', ['slug' => $course->slug]);
                                            } else {
                                                if ($watch_history) {
                                                    $lesson_id = $watch_history->watching_lesson_id;
                                                } elseif ($lesson) {
                                                    $lesson_id = $lesson->id;
                                                }
                                                $url = route('course.player', ['slug' => $course->slug, 'id' => $lesson_id]);
                                            }

                                        ?>
                                        
                                        <?php if($course->expiry_date > 0 && $course->expiry_date < time()): ?>
                                            <a href="<?php echo e(route('purchase.course', ['course_id' => $course->course_id])); ?>" class="eBtn learn-btn w-100 text-center mt-20 f-500">
                                                <?php echo e(get_phrase('Renew')); ?>

                                            </a>
                                        <?php else: ?>
                                            <?php if($course_progress > 0 && $course_progress < 100.00): ?>
                                                <a href="<?php echo e($url); ?>" class="eBtn learn-btn w-100 text-center mt-20 f-500">
                                                    <?php echo e(get_phrase('Continue')); ?>

                                                </a>
                                            <?php elseif($course_progress == 100.00): ?>
                                                <a href="<?php echo e($url); ?>" class="eBtn learn-btn w-100 text-center mt-20 f-500">
                                                    <?php echo e(get_phrase('Watch again')); ?>

                                                </a>
                                            <?php else: ?>
                                                <a href="<?php echo e($url); ?>" class="eBtn learn-btn w-100 text-center mt-20 f-500">
                                                    <?php echo e(get_phrase('Start Now')); ?>

                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($my_courses->count() == 0): ?>
                            <div class="row bg-white radius-10">
                                <div class="com-md-12">
                                    <?php echo $__env->make('frontend.default.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Pagination -->
            <?php if(count($my_courses) > 0): ?>
                <div class="entry-pagination">
                    <nav aria-label="Page navigation example">
                        <?php echo e($my_courses->links()); ?>

                    </nav>
                </div>
            <?php endif; ?>
            <!-- Pagination -->
        </div>
    </section>
    <!------------ My wishlist area End  ------------>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ttelbdtex/public_html/resources/views/frontend/default/student/my_courses/index.blade.php ENDPATH**/ ?>