<?php
    $instructor = course_by_instructor($course_details->id);
?>

<div class="ps-box p-0 shadow-none eInstructor">
    <h4 class="g-title mb-20"><?php echo e(get_phrase('Instructor')); ?></h4>
    <div class="istructor-info">
        <div class="ins-left">
            <img src="<?php echo e(get_image($instructor->photo)); ?>" alt="...">
            <div class="ins-designation">
                <h5><?php echo e(ucfirst($instructor->name)); ?></h5>
                <p class="description">
                    <?php
                        $skills = json_decode($instructor->skills, true);
                        if(is_array($skills) && count($skills) > 0){
                            $skills = array_column($skills, 'value');
                        }
                    ?>
                    <?php echo e($skills ? implode(', ', $skills) : ''); ?>

                </p>
            </div>
        </div>
        <div class="ins-right">
            <p><?php echo e(instructor_rating($instructor->id)); ?></p>
            <ul class="d-flex re-star">
                <li><i class="fa fa-star"></i></li>
                <li><i class="fa fa-star"></i></li>
                <li><i class="fa fa-star"></i></li>
                <li><i class="fa fa-star"></i></li>
                <li><i class="fa fa-star"></i></li>
            </ul>
        </div>
    </div>
    <ul class="instructor-motion">
        <li>
            <img src="<?php echo e(asset('assets/frontend/default/image/m1.png')); ?>" alt="...">
            <?php echo e(count_student_by_instructor($course_details->user_id)); ?>

        </li>
        <li>
            <img src="<?php echo e(asset('assets/frontend/default/image/m2.png')); ?>" alt="...">
            <?php echo e(count_course_by_instructor($instructor->id)); ?>

        </li>
        <li>
            <img src="<?php echo e(asset('assets/frontend/default/image/m3.png')); ?>" alt="...">
            <?php echo e(instructor_reviews($instructor->id)); ?>

        </li>
    </ul>
    <p class="description mt-20 mb-5">
        <?php echo e(ucfirst($instructor->about)); ?>

    </p>
    <a href="<?php echo e(route('instructor.details', ['name' => slugify($instructor->name), 'id' => $instructor->id])); ?>"
        class="eBtn gradient"><?php echo e(get_phrase('View Details')); ?></a>
</div><?php /**PATH /home/ttelbdtex/public_html/resources/views/frontend/default/course/instructor_area.blade.php ENDPATH**/ ?>